﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;
using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class StatusPanel : UserControl
    {
        #region Constructor

        // Constructs a new status panel user control
        public StatusPanel()
        {
            InitializeComponent();
        }

        #endregion


        #region Private Methods

        // Handler for status changed events
        private void MyStatusChangedEventHandler(object sender, StatusUpdateEventArgs args)
        {
            // Update the UI object states
            this.UIThread(() => binaryStatusLabel.Text = args.Status.ToString());
            this.UIThread(() => hexStatusLabel.Text = args.Status.GetValue().ToString("X2"));
            this.UIThread(() => mfrcErrorCheckBox.Checked = args.Status.MFRC_Error);
            
            // Card type logic
            if (args.Status.UL_Type)
            {
                this.UIThread(() => ultralightRadioButton.Checked = true);
            }
            else
            {
                this.UIThread(() => oneKRadioButton.Checked = !args.Status.MF_Type);
                this.UIThread(() => fourKRadioButton.Checked = args.Status.MF_Type);
            }
            
            this.UIThread(() => rs232ErrorCheckBox.Checked = args.Status.RS232_Error);
            this.UIThread(() => rxOK_CheckBox.Checked = args.Status.RxOK);
            this.UIThread(() => CardOkCheckBox.Checked = args.Status.CardOK);
            this.UIThread(() => eepromErrorCheckBox.Checked = args.Status.EEPROM_Error);
        }

        #endregion


        #region Event Handlers

        private void continuousPollCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            // Update continuous poll for associated reader
            Program.Controller.Reader.ContinuousPoll = continuousPollCheckBox.Checked;
            this.UIThread(() => pollNowButton.Enabled = !continuousPollCheckBox.Checked);
        }

        private void pollNowButton_Click(object sender, EventArgs e)
        {
            // Force manual poll for associated reader
            Program.Controller.Reader.CmdUIDRead();
        }

        private void StatusPanel_Load(object sender, EventArgs e)
        {
            // Register for status update events unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                Program.Controller.Reader.StatusUpdateEvent += MyStatusChangedEventHandler;
            }
        }

        private void StatusPanel_VisibleChanged(object sender, EventArgs e)
        {
            // Update the visual elements to match the controller's state unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                if (this.Visible)
                {
                    continuousPollCheckBox.Checked = Program.Controller.Reader.ContinuousPoll;

                    switch (Program.Controller.Reader.Mode)
                    {
                        case Mode.MIFARE:
                            cardTypeGroupBoxPlus.Visible = true;
                            this.statusGroupBox.BackgroundImage = global::MicroRWD.UI.MFIC.Properties.Resources.StatusBg2; 
                            break;

                        case Mode.ICODE:
                            cardTypeGroupBoxPlus.Visible = false;
                            this.statusGroupBox.BackgroundImage = global::MicroRWD.UI.MFIC.Properties.Resources.StatusBg; 
                            break;
                    }
                }
            }
        }

        #endregion
   } 
}
